'use strict';

describe('requests/editRequest.js', function () {

  beforeEach(module('genisis'));

  var $controller, $scope, $user, $api, $rootScope, $sources, $studies,
    $requests, $types, $q, $httpBackend, $window, $comment;

  beforeEach(
    inject(function (_$rootScope_, _$controller_, user, api,
      source, type, request, studyApproval, _$q_, _$httpBackend_,
      _$window_, comment) {
      $controller = _$controller_;
      $rootScope = _$rootScope_;
      $q = _$q_;
      $httpBackend = _$httpBackend_;
      $user = user;
      $sources = source;
      $requests = request;
      $studies = studyApproval;
      $types = type;
      $api = api;
      $window = _$window_;
      $comment = comment;

      $httpBackend.when('GET').respond('test GET response');
      $httpBackend.when('PUT').respond('test PUT respoonse');

      $rootScope.config = {
        apiURL: '/api/'
      };

      $rootScope.errors = [];
      $rootScope.messages = [];
      $rootScope.warnings = [];

      $scope = $rootScope.$new();

      $controller('editRequestCtrl', {
        $scope: $scope,
        $requests: $requests,
        $rootScope: $rootScope,
        $sources: $sources,
        $types: $types,
        $studies: $studies,
        $api: $api,
        $user: $user,
        $routeParams: {
          id: 1
        },
        $comment: $comment
      });
    })
  );

  it('sets $scope.requests to the $requests service', function () {
    expect($scope.requests).toEqual($requests);
  });

  it('sets $scope.request to an empty object', function () {
    expect($scope.request).toEqual({});
  });

  it('sets $scope.studyApprovals to the $studyApprovals service', function () {
    expect($scope.studyApprovals).toEqual($studies);
  });

  it('sets $scope.sources to the $sources service', function () {
    expect($scope.sources).toEqual($sources);
  });

  it('sets $scope.editable to false', function () {
    expect($scope.editable).toEqual(false);
  });

  it('sets $scope.copyRequestAble to true', function () {
    expect($scope.copyRequestAble).toEqual(true);
  });

  it('sets $scope.canApprove and $scope.canReturnToRequester to false',
    function () {
      expect($scope.canApprove).toEqual(false);
      expect($scope.canReturnToRequester).toEqual(false);
    });

  // describe('$scope.loadRequest() function', function () {
  //
  //   var fakeRequest1, fakeRequest2, fakeRequest3, fakeRequest4,
  //     fakeRequest5, fakeRequest6;
  //
  //   beforeEach(function () {
  //     fakeRequest1 = {
  //       id: 1,
  //       statusDescription: 'Draft'
  //     };
  //     fakeRequest2 = {
  //       id: 2,
  //       statusDescription: 'Returned'
  //     };
  //     fakeRequest3 = {
  //       id: 3,
  //       statusDescription: 'Submitted'
  //     };
  //     fakeRequest4 = {
  //       id: 4,
  //       statusDescription: 'Unknown',
  //       reason: 'This is my reason'
  //     };
  //     fakeRequest5 = {
  //       id: 5,
  //       statusDescription: 'Sent'
  //     };
  //     fakeRequest6 = {
  //       id: 6,
  //       statusDescription: 'RequestAccepted'
  //     };
  //
  //
  //     spyOn($requests, 'load').and.callFake(
  //       function () {
  //         var deferred = $q.defer();
  //         deferred.resolve(
  //           [fakeRequest1, fakeRequest2, fakeRequest3,
  //             fakeRequest4, fakeRequest5, fakeRequest6
  //           ]
  //         );
  //         return deferred.promise;
  //       }
  //     );
  //   });
  //
  //   it('finds a draft request and sets $scope.editable = true',
  //     function () {
  //
  //       spyOn($requests, 'find').and.callFake(
  //         function () {
  //           return fakeRequest1;
  //         }
  //       );
  //
  //       $scope.loadRequest(1);
  //       $scope.$apply();
  //       expect($scope.request).toEqual(fakeRequest1);
  //       expect($scope.editable).toEqual(true);
  //       expect($scope.submitted).toEqual(false);
  //       expect($scope.sent).toEqual(false);
  //       expect($scope.accepted).toEqual(false);
  //       expect($scope.copyRequestAble).toEqual(false);
  //       expect($rootScope.warnings).toEqual([]);
  //     });
  //
  //   it('finds a returned request and sets $scope.editable = true',
  //     function () {
  //
  //       spyOn($requests, 'find').and.callFake(
  //         function () {
  //           return fakeRequest2;
  //         }
  //       );
  //
  //       $scope.loadRequest(2);
  //       $scope.$apply();
  //       expect($scope.request).toEqual(fakeRequest2);
  //       expect($scope.editable).toEqual(true);
  //       expect($scope.submitted).toEqual(false);
  //       expect($scope.sent).toEqual(false);
  //       expect($scope.accepted).toEqual(false);
  //       expect($scope.copyRequestAble).toEqual(true);
  //       expect($rootScope.warnings).toEqual([]);
  //     });
  //
  //   it('sets $scope.editable = false and $scope.submitted = false for ' +
  //     'regular users when $request.statusDescription = Submitted',
  //     function () {
  //
  //       spyOn($requests, 'find').and.callFake(
  //         function () {
  //           return fakeRequest3;
  //         }
  //       );
  //
  //       spyOn($user, 'requester').and.returnValue(true);
  //       spyOn($user, 'genisis2Mgr').and.returnValue(false);
  //       spyOn($user, 'vinciMgr').and.returnValue(false);
  //       spyOn($user, 'Administrator').and.returnValue(false);
  //
  //       $scope.loadRequest(3);
  //       $scope.$apply();
  //       expect($scope.request).toEqual(fakeRequest3);
  //       expect($scope.editable).toEqual(false);
  //       expect($scope.copyRequestAble).toEqual(true);
  //       expect($scope.submitted).toEqual(false);
  //       expect($scope.sent).toEqual(false);
  //       expect($scope.accepted).toEqual(false);
  //       expect($rootScope.warnings).toEqual([]);
  //     }
  //   );
  //
  //   it(
  //     'sets $scope.copyRequestAble = false when the user is a vinciMgr',
  //     function () {
  //
  //       spyOn($requests, 'find').and.callFake(
  //         function () {
  //           return fakeRequest3;
  //         }
  //       );
  //
  //       spyOn($user, 'vinciMgr').and.returnValue(true);
  //
  //       $scope.loadRequest(3);
  //       $scope.$apply();
  //       expect($scope.request).toEqual(fakeRequest3);
  //       expect($scope.editable).toEqual(false);
  //       expect($scope.copyRequestAble).toEqual(false);
  //       expect($scope.submitted).toEqual(false);
  //       expect($scope.sent).toEqual(false);
  //       expect($scope.accepted).toEqual(false);
  //       expect($rootScope.warnings).toEqual([]);
  //     }
  //   );
  //
  //   it('sets $scope.submitted = true if the user is a dataManager',
  //     function () {
  //
  //       spyOn($requests, 'find').and.callFake(
  //         function () {
  //           return fakeRequest3;
  //         }
  //       );
  //
  //       spyOn($user, 'requester').and.returnValue(false);
  //       spyOn($user, 'genisis2Mgr').and.returnValue(true);
  //       spyOn($user, 'vinciMgr').and.returnValue(false);
  //       spyOn($user, 'Administrator').and.returnValue(false);
  //
  //       $scope.loadRequest(3);
  //       $scope.$apply();
  //       expect($scope.request).toEqual(fakeRequest3);
  //       expect($scope.editable).toEqual(false);
  //       expect($scope.copyRequestAble).toEqual(true);
  //       expect($scope.submitted).toEqual(true);
  //       expect($scope.sent).toEqual(false);
  //       expect($scope.accepted).toEqual(false);
  //       expect($rootScope.warnings).toEqual([]);
  //     }
  //   );
  //
  //   it('sets $scope.submitted = true if the user is an admin',
  //     function () {
  //
  //       spyOn($requests, 'find').and.callFake(
  //         function () {
  //           return fakeRequest3;
  //         }
  //       );
  //
  //       spyOn($user, 'requester').and.returnValue(false);
  //       spyOn($user, 'genisis2Mgr').and.returnValue(false);
  //       spyOn($user, 'vinciMgr').and.returnValue(false);
  //       spyOn($user, 'Administrator').and.returnValue(true);
  //
  //       $scope.loadRequest(3);
  //       $scope.$apply();
  //       expect($scope.request).toEqual(fakeRequest3);
  //       expect($scope.editable).toEqual(false);
  //       expect($scope.copyRequestAble).toEqual(true);
  //       expect($scope.submitted).toEqual(true);
  //       expect($scope.sent).toEqual(false);
  //       expect($scope.accepted).toEqual(false);
  //       expect($rootScope.warnings).toEqual([]);
  //     }
  //   );
  //
  //   it('sets $scope.sent = false if the user is a dataManager',
  //     function () {
  //
  //       spyOn($requests, 'find').and.callFake(
  //         function () {
  //           return fakeRequest5;
  //         }
  //       );
  //
  //       spyOn($user, 'requester').and.returnValue(false);
  //       spyOn($user, 'genisis2Mgr').and.returnValue(true);
  //       spyOn($user, 'vinciMgr').and.returnValue(false);
  //       spyOn($user, 'Administrator').and.returnValue(false);
  //
  //       $scope.loadRequest(5);
  //       $scope.$apply();
  //       expect($scope.request).toEqual(fakeRequest5);
  //       expect($scope.editable).toEqual(false);
  //       expect($scope.copyRequestAble).toEqual(true);
  //       expect($scope.submitted).toEqual(false);
  //       expect($scope.sent).toEqual(false);
  //       expect($scope.accepted).toEqual(false);
  //       expect($rootScope.warnings).toEqual([]);
  //     }
  //   );
  //
  //   it('sets $scope.sent = true if the user is an admin',
  //     function () {
  //
  //       spyOn($requests, 'find').and.callFake(
  //         function () {
  //           return fakeRequest5;
  //         }
  //       );
  //
  //       spyOn($user, 'requester').and.returnValue(false);
  //       spyOn($user, 'genisis2Mgr').and.returnValue(false);
  //       spyOn($user, 'vinciMgr').and.returnValue(false);
  //       spyOn($user, 'Administrator').and.returnValue(true);
  //
  //       $scope.loadRequest(5);
  //       $scope.$apply();
  //       expect($scope.request).toEqual(fakeRequest5);
  //       expect($scope.editable).toEqual(false);
  //       expect($scope.copyRequestAble).toEqual(true);
  //       expect($scope.submitted).toEqual(false);
  //       expect($scope.sent).toEqual(true);
  //       expect($scope.accepted).toEqual(false);
  //       expect($rootScope.warnings).toEqual([]);
  //     }
  //   );
  //
  //   it('sets $scope.accepted = false if the user is a dataManager',
  //     function () {
  //
  //       spyOn($requests, 'find').and.callFake(
  //         function () {
  //           return fakeRequest6;
  //         }
  //       );
  //
  //       spyOn($user, 'requester').and.returnValue(false);
  //       spyOn($user, 'genisis2Mgr').and.returnValue(true);
  //       spyOn($user, 'vinciMgr').and.returnValue(false);
  //       spyOn($user, 'Administrator').and.returnValue(false);
  //
  //       $scope.loadRequest(6);
  //       $scope.$apply();
  //       expect($scope.request).toEqual(fakeRequest6);
  //       expect($scope.editable).toEqual(false);
  //       expect($scope.copyRequestAble).toEqual(true);
  //       expect($scope.submitted).toEqual(false);
  //       expect($scope.sent).toEqual(false);
  //       expect($scope.accepted).toEqual(false);
  //       expect($rootScope.warnings).toEqual([]);
  //     }
  //   );
  //
  //
  //   it('sets $scope.accepted = true if the user is an admin',
  //     function () {
  //
  //       spyOn($requests, 'find').and.callFake(
  //         function () {
  //           return fakeRequest6;
  //         }
  //       );
  //
  //       spyOn($user, 'requester').and.returnValue(false);
  //       spyOn($user, 'genisis2Mgr').and.returnValue(false);
  //       spyOn($user, 'vinciMgr').and.returnValue(false);
  //       spyOn($user, 'Administrator').and.returnValue(true);
  //
  //       $scope.loadRequest(6);
  //       $scope.$apply();
  //       expect($scope.request).toEqual(fakeRequest6);
  //       expect($scope.editable).toEqual(false);
  //       expect($scope.copyRequestAble).toEqual(true);
  //       expect($scope.submitted).toEqual(false);
  //       expect($scope.sent).toEqual(false);
  //       expect($scope.accepted).toEqual(true);
  //       expect($rootScope.warnings).toEqual([]);
  //     }
  //   );
  //
  //   // it(
  //   //   'pushes request.reason field to $rootScope.warnings if it exists',
  //   //   function () {
  //
  //   //     spyOn($requests, 'find').and.callFake(
  //   //       function () {
  //   //         return fakeRequest4;
  //   //       }
  //   //     );
  //
  //   //     $scope.loadRequest(4);
  //   //     $scope.$apply();
  //   //     expect($rootScope.warnings).toEqual(['This is my reason']);
  //   //   }
  //   // );
  // });

  describe('$scope.loadLogs() function', function () {
    it('exists', function () {
      expect($scope.loadLogs).toBeDefined();
    });

    // it('loads log data', function () {

    //   var fakeLogs = [{commentHistory: []}, {commentHistory: []}];

    //   spyOn($requests, 'logs').and.callFake(
    //     function () {
    //       var deferred = $q.defer();
    //       deferred.resolve(fakeLogs);
    //       return deferred.promise;
    //     });

    //   $scope.loadLogs();
    //   $scope.$apply();
    //   expect($scope.logs).toEqual(fakeLogs);
    // });
  });

  describe('$scope.saveRequest() function', function () {

    it('clears out existing $rootScope.errors', function () {
      var testRequest = {};
      var testMessage = 'this is a test';
      $rootScope.errors.push(testMessage);
      $scope.saveRequest(testRequest);
      expect($rootScope.errors.indexOf(testMessage)).toEqual(-1);
    });

    it('clears out existing $rootScope.messages', function () {
      var testRequest = {};
      var testMessage = 'this is a test';
      $rootScope.messages.push(testMessage);
      $scope.saveRequest(testRequest);
      expect($rootScope.messages.indexOf(testMessage)).toEqual(-1);
    });

    it('checks for a valid request title', function () {
      var testRequest = {};
      expect($scope.saveRequest(testRequest)).toEqual(false);
      // expect($rootScope.errors).toEqual([
      //   'You must enter a request title.'
      // ]);
    });

    it('checks for a valid source', function () {
      var testRequest = {
        title: 'test title'
      };
      expect($scope.saveRequest(testRequest)).toEqual(false);
      // expect($rootScope.errors).toEqual([
      //   'You must select a source.'
      // ]);
    });

    it('checks for a valid study approval', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1
      };
      expect($scope.saveRequest(testRequest)).toEqual(false);
      // expect($rootScope.errors).toEqual([
      //   'You must select an approved study.'
      // ]);
    });

    it('checks for a valid request type', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2
      };
      expect($scope.saveRequest(testRequest)).toEqual(false);
      // expect($rootScope.errors).toEqual([
      //   'You must select a request type.'
      // ]);
    });

    it('checks for a valid notify collaborators', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        type: 3
      };
      expect($scope.saveRequest(testRequest)).toEqual(false);
      // expect($rootScope.errors).toEqual(
      //   [
      //     'You must select whether or not to notify collaborators.'
      //   ]
      // );
    });

    it('checks for a valid notify collaborators', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        type: 3
      };
      expect($scope.saveRequest(testRequest)).toEqual(false);
      // expect($rootScope.errors).toEqual(
      //   [
      //     'You must select whether or not to notify collaborators.'
      //   ]
      // );
    });

    it('checks for a valid request description', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true
      };
      expect($scope.saveRequest(testRequest)).toEqual(false);
      // expect($rootScope.errors).toEqual(
      //   ['You must enter a request description.']
      // );
    });

    it('creates a request', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {}
          });
          return deferred.promise;
        }
      );

      $scope.saveRequest(testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual([]);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([
      //   'Your changes have been saved.'
      // ]);
    });

    it('returns an error if the API fails', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false,
            message: 'api error'
          });
          return deferred.promise;
        });

      $scope.saveRequest(testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual(['api error']);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([]);
    });

    it('handles no api response', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({});
          return deferred.promise;
        });

      $scope.saveRequest(testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual([
      //   'Save request API call failed.'
      // ]);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([]);
    });
  });

  describe('$scope.submitRequest() function', function () {
    it('exists', function () {
      expect($scope.submitRequest).toBeDefined();
    });

    it('clears out any existing $rootScope.errors', function () {
      var testError = 'this is a test error';

      $rootScope.errors.push(testError);

      $scope.submitRequest({});
      $scope.$apply();
      expect($rootScope.errors.indexOf(testError)).toEqual(-1);
    });

    it('clears out any existing $rootScope.messages', function () {
      var testMessage = 'this is a test error';

      $rootScope.messages.push(testMessage);

      $scope.submitRequest({});
      $scope.$apply();
      expect($rootScope.messages.indexOf(testMessage)).toEqual(-1);
    });

    it('returns $rootScope.errors if the request has no title',
      function () {

        var fakeRequest = {};

        expect($scope.submitRequest(fakeRequest)).toEqual(false);
        // expect($rootScope.errors).toEqual([
        //   'You must enter a request title.'
        // ]);
      });

    it('returns $rootScope.errors if the request has no source',
      function () {

        var fakeRequest = {
          title: 'test title'
        };

        expect($scope.submitRequest(fakeRequest)).toEqual(false);
        // expect($rootScope.errors).toEqual([
        //   'You must select a source.'
        // ]);
      });

    it('returns $rootScope.errors if the request has no study approval',
      function () {

        var fakeRequest = {
          title: 'test title',
          sourceId: 1
        };

        expect($scope.submitRequest(fakeRequest)).toEqual(false);
        // expect($rootScope.errors).toEqual(
        //   ['You must select an approved study.']
        // );
      }
    );

    it('returns $rootScope.errors if the request has no request type',
      function () {

        var fakeRequest = {
          title: 'test title',
          sourceId: 1,
          studyApprovalId: 2
        };

        expect($scope.submitRequest(fakeRequest)).toEqual(false);
        // expect($rootScope.errors).toEqual([
        //   'You must select a request type.'
        // ]);
      }
    );

    it('returns $rootScope.errors if the request has no notify value',
      function () {
        var fakeRequest = {
          title: 'test title',
          sourceId: 1,
          studyApprovalId: 2,
          requestTypeId: 3
        };

        expect($scope.submitRequest(fakeRequest)).toEqual(false);
        // expect($rootScope.errors).toEqual(
        //   [
        //     'You must select whether or not to notify collaborators.'
        //   ]
        // );
      }
    );

    it('returns $rootScope.errors if the request has no description',
      function () {

        var fakeRequest = {
          title: 'test title',
          sourceId: 1,
          studyApprovalId: 2,
          requestTypeId: 3,
          notify: true
        };

        expect($scope.submitRequest(fakeRequest)).toEqual(false);
        // expect($rootScope.errors).toEqual(
        //   ['You must enter a request description.']
        // );
      }
    );

    it('submits the request by calling $api.update() function',
      function () {

        var fakeRequest = {
          title: 'test title',
          sourceId: 1,
          studyApprovalId: 2,
          requestTypeId: 3,
          notify: true,
          description: 'test description'
        };

        spyOn($api, 'update').and.callFake(function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {}
          });
          return deferred.promise;
        });

        var promise = $scope.submitRequest(fakeRequest);

        promise.then(function (data) {
          expect(data).toEqual(true);
          expect($scope.editable).toEqual(false);
          expect(fakeRequest.statusDescription).toEqual(
            'Submitted');
          // expect($rootScope.messages).toEqual(
          //   [
          //     'Your request has been submitted to your data manager.'
          //   ]
          // );
          // expect($rootScope.errors).toEqual([]);
        });

        $scope.$apply();
        expect($api.update.calls.count()).toEqual(1);
      });

    it('returns $rootScope.errors if the api call fails', function () {

      var fakeRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(function () {
        var deferred = $q.defer();
        deferred.resolve({
          success: false,
          message: 'api error',
          response: {}
        });
        return deferred.promise;
      });

      var promise = $scope.submitRequest(fakeRequest);

      promise.then(function (data) {
        expect(data).toEqual(false);
        // expect($rootScope.errors).toEqual(['api error']);
      });

      $scope.$apply();
      expect($api.update.calls.count()).toEqual(1);
    });

    it('returns $rootScope.errors if the api errors', function () {

      var fakeRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(function () {
        var deferred = $q.defer();
        deferred.resolve({});
        return deferred.promise;
      });

      var promise = $scope.submitRequest(fakeRequest);

      promise.then(function (data) {
        expect(data).toEqual(false);
        // expect($rootScope.errors).toEqual([
        //   'Submit request API call failed.'
        // ]);
      });

      $scope.$apply();
      expect($api.update.calls.count()).toEqual(1);
    });
  });

  describe('$scope.approveRequest() function', function () {
    it('exists', function () {
      expect($scope.approveRequest).toBeDefined();
    });

    it('clears out any existing $rootScope.errors', function () {
      var testError = 'this is a test error';

      $rootScope.errors.push(testError);

      $scope.approveRequest({});
      $scope.$apply();
      expect($rootScope.errors.indexOf(testError)).toEqual(-1);
    });

    it('clears out any existing $rootScope.messages', function () {
      var testMessage = 'this is a test error';

      $rootScope.messages.push(testMessage);

      $scope.approveRequest({});
      $scope.$apply();
      expect($rootScope.messages.indexOf(testMessage)).toEqual(-1);
    });

    it('approves the request by calling $api.update() function',
      function () {

        var fakeRequest = {
          title: 'test title',
          sourceId: 1,
          studyApprovalId: 2,
          requestTypeId: 3,
          notify: true,
          description: 'test description',
          statusDescription: 'Submitted'
        };

        spyOn($api, 'update').and.callFake(function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {}
          });
          return deferred.promise;
        });

        var promise = $scope.approveRequest(fakeRequest);

        promise.then(function (data) {
          expect(data).toEqual(true);
          expect($scope.editable).toEqual(false);
          expect(fakeRequest.statusDescription).toEqual('Sent');
          // expect($rootScope.messages).toEqual(
          //   ['The request has been approved.']
          // );
          // expect($rootScope.errors).toEqual([]);
        });

        $scope.$apply();
        expect($api.update.calls.count()).toEqual(1);
      });

    it('returns $rootScope.errors if the api call fails', function () {

      var fakeRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(function () {
        var deferred = $q.defer();
        deferred.resolve({
          success: false,
          message: 'api error',
          response: {}
        });
        return deferred.promise;
      });

      var promise = $scope.approveRequest(fakeRequest);

      promise.then(function (data) {
        expect(data).toEqual(false);
        // expect($rootScope.errors).toEqual(['api error']);
      });

      $scope.$apply();
      expect($api.update.calls.count()).toEqual(1);
    });

    it('returns $rootScope.errors if the api errors', function () {

      var fakeRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(function () {
        var deferred = $q.defer();
        deferred.resolve({});
        return deferred.promise;
      });

      var promise = $scope.approveRequest(fakeRequest);

      promise.then(function (data) {
        expect(data).toEqual(false);
        // expect($rootScope.errors).toEqual([
        //   'Approve request API call failed.'
        // ]);
      });

      $scope.$apply();
      expect($api.update.calls.count()).toEqual(1);
    });
  });

  describe('$scope.returnRequest() function', function () {

    it('exists', function () {
      expect($scope.returnRequest).toBeDefined();
    });

    it('clears out any existing $rootScope.errors', function () {
      var testError = 'this is a test error';

      $rootScope.errors.push(testError);

      $scope.returnRequest('test', {
        id: 1
      });
      $scope.$apply();
      expect($rootScope.errors.indexOf(testError)).toEqual(-1);
    });

    it('clears out any existing $rootScope.messages', function () {
      var testMessage = 'this is a test error';

      $rootScope.messages.push(testMessage);

      $scope.approveRequest('test');
      $scope.$apply();
      expect($rootScope.messages.indexOf(testMessage)).toEqual(-1);
    });

    it('returns false if no message parameter is provided', function () {
      var results = $scope.returnRequest(null);
      expect(results).toEqual(false);
      // expect($rootScope.errors).toEqual(
      //   ['Enter a reason why you\'re denying this request in ' +
      //     'the comment field.'
      //   ]
      // );
    });

    it('rejects a request', function () {

      var fakeRequest = {
        id: 'fake',
        statusDescription: 'Submitted'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {}
          });
          return deferred.promise;
        }
      );

      var promise = $scope.returnRequest('test mesage', fakeRequest);

      promise.then(function (data) {
        expect(data).toEqual(true);
        expect($scope.canApprove).toEqual(false);
        expect($scope.canReturnToRequester).toEqual(false);
        expect(fakeRequest.statusDescription).toEqual(
          'Returned');
        // expect($rootScope.messages).toEqual(
        //   [
        //     'This request has been returned to the owner.'
        //   ]
        // );
      });

      $scope.$apply();
    });

    it('returns $rootScope.errors if the API call fails', function () {

      var fakeRequest = {
        id: 'fake',
        statusDescription: 'Submitted'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false,
            message: 'api error',
            response: {}
          });
          return deferred.promise;
        }
      );

      var promise = $scope.returnRequest('test mesage', fakeRequest);

      promise.then(function (data) {
        expect(data).toEqual(false);
        expect($scope.canApprove).toEqual(false);
        expect($scope.canReturnToRequester).toEqual(false);
        expect(fakeRequest.statusDescription).toEqual(
          'Submitted');
        // expect($rootScope.messages).toEqual([]);
        // expect($rootScope.errors).toEqual(['api error']);
      });

      $scope.$apply();
    });

    it('returns $rootScope.errors if the API does not respond',
      function () {

        var fakeRequest = {
          id: 'fake',
          statusDescription: 'Submitted'
        };

        spyOn($api, 'update').and.callFake(
          function () {
            var deferred = $q.defer();
            deferred.resolve({});
            return deferred.promise;
          }
        );

        var promise = $scope.returnRequest('test mesage', fakeRequest);

        promise.then(function (data) {
          expect(data).toEqual(false);
          expect($scope.canApprove).toEqual(false);
          expect($scope.canReturnToRequester).toEqual(false);
          expect(fakeRequest.statusDescription).toEqual(
            'Submitted');
          // expect($rootScope.messages).toEqual([]);
          // expect($rootScope.errors).toEqual([
          //   'Reject request API call failed.'
          // ]);
        });

        $scope.$apply();
      }
    );
  });

  describe('$scope.denyRequest() function', function () {

    it('exists', function () {
      expect($scope.denyRequest).toBeDefined();
    });

    it('clears out any existing $rootScope.errors', function () {
      var testError = 'this is a test error';

      $rootScope.errors.push(testError);

      $scope.denyRequest('test', {
        id: 1
      });
      $scope.$apply();
      expect($rootScope.errors.indexOf(testError)).toEqual(-1);
    });

    it('clears out any existing $rootScope.messages', function () {
      var testMessage = 'this is a test error';

      $rootScope.messages.push(testMessage);

      $scope.denyRequest('test', {
        id: 1
      });
      $scope.$apply();
      expect($rootScope.messages.indexOf(testMessage)).toEqual(-1);
    });

    it('returns false if no message parameter is provided', function () {
      var results = $scope.denyRequest(null);
      expect(results).toEqual(false);
      // expect($rootScope.errors).toEqual(
      //   ['Enter a reason why you\'re denying this request in ' +
      //     'the comment field.'
      //   ]
      // );
    });

    it('denies a request', function () {

      var fakeRequest = {
        id: 'fake',
        statusDescription: 'Submitted'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {}
          });
          return deferred.promise;
        }
      );

      var promise = $scope.denyRequest('test mesage', fakeRequest);

      promise.then(function (data) {
        expect(data).toEqual(true);
        expect($scope.canApprove).toEqual(false);
        expect($scope.canReturnToRequester).toEqual(false);
        expect($scope.editable).toEqual(false);
        expect(fakeRequest.statusDescription).toEqual('Denied');
        // expect($rootScope.messages).toEqual(
        //   [
        //     'This request has been denied.'
        //   ]
        // );
      });

      $scope.$apply();
    });

    it('returns $rootScope.errors if the API call fails', function () {

      var fakeRequest = {
        id: 'fake',
        statusDescription: 'Submitted'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false,
            message: 'api error',
            response: {}
          });
          return deferred.promise;
        }
      );

      var promise = $scope.denyRequest('test mesage', fakeRequest);

      promise.then(function (data) {
        expect(data).toEqual(false);
        expect($scope.canApprove).toEqual(false);
        expect($scope.canReturnToRequester).toEqual(false);
        expect(fakeRequest.statusDescription).toEqual(
          'Submitted');
        // expect($rootScope.messages).toEqual([]);
        // expect($rootScope.errors).toEqual(['api error']);
      });

      $scope.$apply();
    });

    it('returns $rootScope.errors if the API does not respond',
      function () {

        var fakeRequest = {
          id: 'fake',
          statusDescription: 'Submitted'
        };

        spyOn($api, 'update').and.callFake(
          function () {
            var deferred = $q.defer();
            deferred.resolve({});
            return deferred.promise;
          }
        );

        var promise = $scope.denyRequest('test mesage', fakeRequest);

        promise.then(function (data) {
          expect(data).toEqual(false);
          expect($scope.canApprove).toEqual(false);
          expect($scope.canReturnToRequester).toEqual(false);
          expect(fakeRequest.statusDescription).toEqual(
            'Submitted');
          // expect($rootScope.messages).toEqual([]);
          // expect($rootScope.errors).toEqual([
          //   'Deny request API call failed.'
          // ]);
        });

        $scope.$apply();
      }
    );
  });

  describe('$scope.cancelRequest()', function () {
    it('comments exceeds 3000 characters', function () {
      var fakeRequest = {
        comments: 'something that is 3000 over, but I mocked you!',
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false,
            response: {}
          });
          return deferred.promise;
        }
      );

      spyOn($requests, 'exceededMaxCharacters').and.callFake(
        function () {
          return true;
        }
      );

      spyOn($window, 'alert');
      $scope.cancelRequest(fakeRequest);
      expect(window.alert).toHaveBeenCalledWith(
        'Comment exceeds 3000 characters'
      );
      $scope.$apply();
      expect($api.update.calls.count()).toEqual(0);
    });

    it('cancels request successfully', function () {
      var fakeRequest = {
        comments: 'something that is 3000 over, but I mocked you!',
        commentType: 'general',
        statusDescription: 'testStatus'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {
              id: 1
            }
          });
          return deferred.promise;
        }
      );

      spyOn($requests, 'exceededMaxCharacters').and.callFake(
        function () {
          return false;
        }
      );

      spyOn($comment, 'initConfirm').and.callFake(
        function () {
          return false;
        }
      );

      spyOn($window, 'confirm').and.callFake(
        function () {
          return true;
        }
      );

      var promise = $scope.cancelRequest(fakeRequest);
      spyOn($window, 'alert');

      promise.then(function (data) {
        expect(data).toEqual(true);
        expect($scope.canApprove).toEqual(false);
        expect($scope.canReturnToRequester).toEqual(false);
        expect($scope.editable).toEqual(false);
        expect($scope.delivered).toEqual(false);
        expect($scope.canAccept).toEqual(false);
        expect($scope.canNotBeFulfilled).toEqual(false);
        expect($scope.accepted).toEqual(false);
        expect(fakeRequest.statusDescription).toEqual(
          'Cancelled');
        expect(window.alert).toHaveBeenCalledWith(
          'Request 1 successfully cancelled.'
        );
      });
      $scope.$apply();
      expect($api.update.calls.count()).toEqual(1);
    });
  });

  describe('$scope.acceptData() function', function () {
    it('exists', function () {
      expect($scope.acceptData).toBeDefined();
    });

    it('clears out existing $rootScope.errors', function () {
      var testRequest = {};
      var testMessage = 'this is a test';
      $rootScope.errors.push(testMessage);
      $scope.acceptData(testRequest);
      expect($rootScope.errors.indexOf(testMessage)).toEqual(-1);
    });

    it('clears out existing $rootScope.messages', function () {
      var testRequest = {};
      var testMessage = 'this is a test';
      $rootScope.messages.push(testMessage);
      $scope.acceptData(testRequest);
      expect($rootScope.messages.indexOf(testMessage)).toEqual(-1);
    });

    it('approves the requests data', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        status: 'Sent',
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {}
          });
          return deferred.promise;
        }
      );

      $scope.acceptData(testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual([]);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([
      //   'This request\'s data has been accepted.'
      // ]);
      expect($scope.editable).toEqual(false);
      expect($scope.canApprove).toEqual(false);
      expect($scope.canReturnToRequester).toEqual(false);
      expect($scope.canAccept).toEqual(false);
      expect($scope.canNotBeFulfilled).toEqual(false);
      expect($scope.accepted).toEqual(true);
      expect(testRequest.statusDescription).toEqual(
        'RequestAccepted');
    });

    it('returns an error if the API fails', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false,
            message: 'api error'
          });
          return deferred.promise;
        });

      $scope.acceptData(testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual(['api error']);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([]);
    });

    it('handles no api response', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({});
          return deferred.promise;
        });

      $scope.acceptData(testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual([
      //   'Accept data request API call failed.'
      // ]);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([]);
    });
  });

  describe('$scope.denyData() function', function () {
    it('exists', function () {
      expect($scope.denyData).toBeDefined();
    });

    it('clears out existing $rootScope.errors', function () {
      var testRequest = {};
      var testMessage = 'this is a test';
      $rootScope.errors.push(testMessage);
      $scope.denyData(testMessage, testRequest);
      expect($rootScope.errors.indexOf(testMessage)).toEqual(-1);
    });

    it('clears out existing $rootScope.messages', function () {
      var testRequest = {};
      var testMessage = 'this is a test';
      $rootScope.messages.push(testMessage);
      $scope.denyData(testMessage, testRequest);
      expect($rootScope.messages.indexOf(testMessage)).toEqual(-1);
    });

    it('Denies the requests data', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        status: 'Sent',
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {}
          });
          return deferred.promise;
        }
      );

      $scope.denyData('test', testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual([]);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([
      //   'This request has been denied because the ' +
      // 'request cannot be fulfilled.'
      // ]);
      expect($scope.editable).toEqual(false);
      expect($scope.canApprove).toEqual(false);
      expect($scope.canReturnToRequester).toEqual(false);
      expect($scope.canAccept).toEqual(false);
      expect($scope.canNotBeFulfilled).toEqual(false);
      expect($scope.accepted).toEqual(false);
      expect(testRequest.statusDescription).toEqual(
        'RequestNotAccepted');
    });

    it('returns an error if the API fails', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        // notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false,
            message: 'api error'
          });
          return deferred.promise;
        });

      $scope.denyData('test', testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual(['api error']);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([]);
    });

    it('handles no api response', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({});
          return deferred.promise;
        });

      $scope.denyData('test', testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual([
      //   'Deny data request API call failed.'
      // ]);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([]);
    });
  });

  describe('$scope.acceptResults() function', function () {
    it('exists', function () {
      expect($scope.acceptResults).toBeDefined();
    });

    it('clears out existing $rootScope.errors', function () {
      var testRequest = {};
      var testMessage = 'this is a test';
      $rootScope.errors.push(testMessage);
      $scope.acceptResults(testRequest);
      expect($rootScope.errors.indexOf(testMessage)).toEqual(-1);
    });

    it('clears out existing $rootScope.messages', function () {
      var testRequest = {};
      var testMessage = 'this is a test';
      $rootScope.messages.push(testMessage);
      $scope.acceptResults(testRequest);
      expect($rootScope.messages.indexOf(testMessage)).toEqual(-1);
    });

    it('accepts the requests results', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        status: 'Sent',
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {}
          });
          return deferred.promise;
        }
      );

      $scope.acceptResults(testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual([]);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([
      //   'This request\'s data has been accepted.'
      // ]);
      expect($scope.editable).toEqual(false);
      expect($scope.canApprove).toEqual(false);
      expect($scope.canReturnToRequester).toEqual(false);
      expect($scope.canAccept).toEqual(false);
      expect($scope.canNotBeFulfilled).toEqual(false);
      expect($scope.accepted).toEqual(false);
      expect(testRequest.statusDescription).toEqual(
        'ResultsAccepted');
    });

    it('returns an error if the API fails', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false,
            message: 'api error'
          });
          return deferred.promise;
        });

      $scope.acceptResults(testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual(['api error']);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([]);
    });

    it('handles no api response', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({});
          return deferred.promise;
        });

      $scope.acceptResults(testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual([
      //   'Accept results request API call failed.'
      // ]);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([]);
    });
  });

  describe('$scope.denyResults() function', function () {
    it('exists', function () {
      expect($scope.denyResults).toBeDefined();
    });

    it('clears out existing $rootScope.errors', function () {
      var testRequest = {};
      var testMessage = 'this is a test';
      $rootScope.errors.push(testMessage);
      $scope.denyResults(testMessage, testRequest);
      expect($rootScope.errors.indexOf(testMessage)).toEqual(-1);
    });

    it('clears out existing $rootScope.messages', function () {
      var testRequest = {};
      var testMessage = 'this is a test';
      $rootScope.messages.push(testMessage);
      $scope.denyResults(testMessage, testRequest);
      expect($rootScope.messages.indexOf(testMessage)).toEqual(-1);
    });

    it('Denies the requests results', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        status: 'Sent',
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {}
          });
          return deferred.promise;
        }
      );

      $scope.denyResults('test', testRequest);
      $scope.$apply();

      expect($rootScope.errors).toEqual([]);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([
      //   'This request\'s data has been rejected '+
      // 'by the data manager.'
      // ]);
      expect($scope.editable).toEqual(false);
      expect($scope.canApprove).toEqual(false);
      expect($scope.canReturnToRequester).toEqual(false);
      expect($scope.canAccept).toEqual(false);
      expect($scope.canNotBeFulfilled).toEqual(false);
      expect($scope.accepted).toEqual(false);
      expect(testRequest.statusDescription).toEqual(
        'ResultsNotAccepted');
    });

    it('returns an error if the API fails', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false,
            message: 'api error'
          });
          return deferred.promise;
        });

      $scope.denyResults('test', testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual(['api error']);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([]);
    });

    it('handles no api response', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({});
          return deferred.promise;
        });

      $scope.denyResults('test', testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual([
      //   'Deny results request API call failed.'
      // ]);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([]);
    });
  });
  describe('$scope.returnToDDM() function', function () {
    it('exists', function () {
      expect($scope.returnToDDM).toBeDefined();
    });

    it('clears out existing $rootScope.errors', function () {
      var testRequest = {};
      var testMessage = 'this is a test';
      $rootScope.errors.push(testMessage);
      $scope.returnToDDM(testMessage, testRequest);
      expect($rootScope.errors.indexOf(testMessage)).toEqual(-1);
    });

    it('clears out existing $rootScope.messages', function () {
      var testRequest = {};
      var testMessage = 'this is a test';
      $rootScope.messages.push(testMessage);
      $scope.returnToDDM(testMessage, testRequest);
      expect($rootScope.messages.indexOf(testMessage)).toEqual(-1);
    });

    it('Returns to DDM from Sent status', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        status: 'Sent',
        description: 'test description'
      };
      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {}
          });
          return deferred.promise;
        }
      );

      $scope.returnToDDM('test', testRequest);
      $scope.$apply();

      expect($rootScope.errors).toEqual([]);
      expect($api.update.calls.count()).toEqual(1);
      expect($scope.canAccept).toEqual(false);
      expect($scope.canNotBeFulfilled).toEqual(false);
      expect($scope.accepted).toEqual(false);
      expect($scope.canReturnToDDM).toEqual(false);
      expect(testRequest.statusDescription).toEqual(
        'Submitted');
    });
    it('Returns to DDM from RequestAccepted status', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        status: 'RequestAccepted',
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {}
          });
          return deferred.promise;
        }
      );

      $scope.returnToDDM('test', testRequest);
      $scope.$apply();

      expect($rootScope.errors).toEqual([]);
      expect($api.update.calls.count()).toEqual(1);
      expect($scope.canAccept).toEqual(false);
      expect($scope.canNotBeFulfilled).toEqual(false);
      expect($scope.accepted).toEqual(false);
      expect($scope.canReturnToDDM).toEqual(false);
      expect(testRequest.statusDescription).toEqual(
        'Submitted');
    });

    it('returns an error if the API fails', function () {
      var testRequest = {
        title: 'test title',
        sourceId: 1,
        studyApprovalId: 2,
        requestTypeId: 3,
        notify: true,
        description: 'test description'
      };

      spyOn($api, 'update').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false,
            message: 'api error'
          });
          return deferred.promise;
        });

      $scope.returnToDDM('test', testRequest);
      $scope.$apply();

      // expect($rootScope.errors).toEqual(['api error']);
      expect($api.update.calls.count()).toEqual(1);
      // expect($rootScope.messages).toEqual([]);
    });
  });

  describe('$scope.setTableCopy() function', function () {
    it('exists', function () {
      expect($scope.setTableCopy).toBeDefined();
    });

    it('sets canCopyTable flag to true if dataManager' +
      'and currentStatus is correct',
      function () {
        var request = {
          statusDescription: 'ResultsDelivered',
          requestTypeId: 1
        };
        spyOn($user, 'genisis2Mgr').and.returnValue(true);
        $scope.setTableCopy(request);
        $scope.$apply();
        expect($scope.canCopyTable).toEqual(true);
      });

    it('sets canCopyTable flag to false if not dataManager ' +
      'and currentStatus is correct',
      function () {
        var request = {
          statusDescription: 'ResultsDelivered',
          requestTypeId: 1
        };
        spyOn($user, 'genisis2Mgr').and.returnValue(false);
        $scope.setTableCopy(request);
        $scope.$apply();
        expect($scope.canCopyTable).toEqual(false);
      });

    it('sets canCopyTable flag to false if not dataManager' +
      'and currentStatus is incorrect',
      function () {
        var request = {
          statusDescription: 'test'
        };
        spyOn($user, 'genisis2Mgr').and.returnValue(false);
        $scope.setTableCopy(request);
        $scope.$apply();
        expect($scope.canCopyTable).toEqual(false);
      });
  });

  describe('$scope.enableCopyTable() function', function () {
    it('successfully calls api and sets copyTableData', function () {
      spyOn($api, 'retrieve').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            message: null,
            response: {
              test: 'test'
            }
          });
          return deferred.promise;
        });

      $scope.enableCopyTable();
      $scope.$apply();

      expect($scope.copyTableData).toEqual({
        test: 'test'
      });
    });
  });

  describe('$scope.disableCopyTable', function () {
    it('sets canCopyTable flag to false', function () {
      $scope.canCopyTable = true;
      $scope.$apply();
      expect($scope.canCopyTable).toEqual(true);
      $scope.disableCopyTable();
      $scope.$apply();
      expect($scope.canCopyTable).toEqual(false);
    });
  });

  describe('$scope.clearCopyTableForm', function () {
    it('clears copyTableData object', function () {
      $scope.copyTableData = {
        test: 'test',
        tableName: 'test',
        sourceSchemaName: 'test',
        destinationSchemaName: 'test'
      };
      $scope.$apply();
      expect($scope.copyTableData).toEqual({
        test: 'test',
        tableName: 'test',
        sourceSchemaName: 'test',
        destinationSchemaName: 'test'
      });
      $scope.clearCopyTableForm();
      $scope.$apply();
      expect($scope.copyTableData).toEqual({
        test: 'test',
        tableName: null,
        sourceSchemaName: null,
        destinationSchemaName: null
      });
    });
  });

  describe('$scope.submitCopyTableData', function () {
    it('successfully copied', function () {
      spyOn($api, 'create').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            message: null,
            response: 'test'
          });
          return deferred.promise;
        });

      spyOn($api, 'retrieve').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            message: null,
            response: [{
              test: 'test'
            }]
          });
          return deferred.promise;
        });

      expect($scope.logs).toEqual([]);
      $scope.copyTableData = {
        test: 'test',
        tableName: 'test',
        sourceSchemaName: 'test',
        destinationSchemaName: 'test'
      };
      expect($scope.copyTableData).toEqual({
        test: 'test',
        tableName: 'test',
        sourceSchemaName: 'test',
        destinationSchemaName: 'test'
      });
      $scope.canCopyTable = false;
      expect($scope.canCopyTable).toEqual(false);
      $scope.copyingTable = true;
      expect($scope.copyingTable).toEqual(true);
      // expect($rootScope.messages).toEqual([]);

      $scope.submitCopyTableData({
        tableName: 'test',
        sourceSchemaName: 'test',
        destinationSchemaName: 'test'
      });
      $scope.$apply();

      expect($scope.copyTableData).toEqual({
        test: 'test',
        tableName: 'test',
        sourceSchemaName: 'test',
        destinationSchemaName: 'test'
      });
      expect($scope.canCopyTable).toEqual(false);
      expect($scope.copyingTable).toEqual(false);
      // expect($rootScope.messages.length).toEqual(1);
      expect($api.retrieve.calls.count()).toEqual(1);
      expect($api.create.calls.count()).toEqual(1);
    });

    it('failed to copy due to blank tableName', function () {
      $scope.canCopyTable = false;
      expect($scope.canCopyTable).toEqual(false);
      $scope.copyingTable = true;
      expect($scope.copyingTable).toEqual(true);
      // expect($rootScope.messages).toEqual([]);
      // expect($rootScope.errors).toEqual([]);

      $scope.submitCopyTableData({
        tableName: null
      });
      $scope.$apply();
      expect($scope.copyTableData).toEqual({});
      expect($scope.canCopyTable).toEqual(true);
      expect($scope.copyingTable).toEqual(false);
      // expect($rootScope.errors.length).toEqual(1);
      // expect($rootScope.errors[0]).toEqual('Please enter' +
      //   ' a table name.');
    });

    it('failed to copy due to message', function () {
      spyOn($api, 'create').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            message: 'test'
          });
          return deferred.promise;
        });

      expect($scope.logs).toEqual([]);
      $scope.copyTableData = {
        test: 'test'
      };
      expect($scope.copyTableData).toEqual({
        test: 'test'
      });
      $scope.canCopyTable = false;
      expect($scope.canCopyTable).toEqual(false);
      $scope.copyingTable = true;
      expect($scope.copyingTable).toEqual(true);
      // expect($rootScope.messages).toEqual([]);

      $scope.submitCopyTableData({
        tableName: 'test',
        sourceSchemaName: 'test',
        destinationSchemaName: 'test'
      });
      $scope.$apply();

      expect($scope.copyTableData).toEqual({
        test: 'test'
      });
      expect($scope.canCopyTable).toEqual(false);
      expect($scope.copyingTable).toEqual(false);
      // expect($rootScope.messages.length).toEqual(0);
      // expect($rootScope.errors.length).toEqual(1);
      expect($api.create.calls.count()).toEqual(1);
    });

    it('failed to copy due to system error', function () {
      spyOn($api, 'create').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false
          });
          return deferred.promise;
        });

      expect($scope.logs).toEqual([]);
      $scope.copyTableData = {
        test: 'test'
      };
      expect($scope.copyTableData).toEqual({
        test: 'test'
      });
      $scope.canCopyTable = false;
      expect($scope.canCopyTable).toEqual(false);
      $scope.copyingTable = true;
      expect($scope.copyingTable).toEqual(true);
      expect($rootScope.messages).toEqual([]);

      $scope.submitCopyTableData({
        tableName: 'test',
        sourceSchemaName: 'test',
        destinationSchemaName: 'test'
      });
      $scope.$apply();

      expect($scope.copyTableData).toEqual({
        test: 'test'
      });
      expect($scope.canCopyTable).toEqual(false);
      expect($scope.copyingTable).toEqual(false);
      // expect($rootScope.messages.length).toEqual(0);
      // expect($rootScope.errors.length).toEqual(1);
      // expect($rootScope.errors[0]).toEqual('Failed to communicate' +
      //   ' with system, please try again.');
      expect($api.create.calls.count()).toEqual(1);
    });
  });

  describe('$scope.submitComment', function () {
    it('fails to submit due to exceededMaxCharacters', function () {
      spyOn($api, 'create').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false
          });
          return deferred.promise;
        });

      spyOn($requests, 'exceededMaxCharacters').and.callFake(
        function () {
          return true;
        });

      spyOn($window, 'alert');
      $scope.submitComment({});
      expect(window.alert).toHaveBeenCalledWith(
        'Comment exceeds 3000 characters'
      );
      $scope.$apply();
      expect($api.create.calls.count()).toEqual(0);
    });

    it('fails to submit due to no comment inputted', function () {
      spyOn($api, 'create').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: false
          });
          return deferred.promise;
        });

      spyOn($requests, 'exceededMaxCharacters').and.callFake(
        function () {
          return false;
        });

      spyOn($window, 'alert');
      $scope.submitComment({});
      expect(window.alert).toHaveBeenCalledWith(
        'Please enter a comment and try again.'
      );

      $scope.$apply();
      expect($api.create.calls.count()).toEqual(0);
    });

    it('fails to submit comment due to API error', function () {
      var data = {
        success: false,
        response: {},
        message: ''
      };
      spyOn($api, 'create').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve(data);
          return deferred.promise;
        });

      spyOn($requests, 'exceededMaxCharacters').and.callFake(
        function () {
          return false;
        });

      spyOn($api, 'errorAlert');

      var promise = $scope.submitComment({
        comments: 'test'
      });

      promise.then(function (data) {
        expect(data).toEqual(data);
        expect($api.errorAlert).toHaveBeenCalled();
      });

      $scope.$apply();
      expect($api.create.calls.count()).toEqual(1);
    });

    it('successfully submit comment', function () {
      var data = {
        success: true,
        response: {
          test: 'test'
        },
        message: ''
      };
      spyOn($api, 'create').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve(data);
          return deferred.promise;
        });

      spyOn($requests, 'exceededMaxCharacters').and.callFake(
        function () {
          return false;
        });

      spyOn($window, 'alert');
      spyOn($scope, 'loadLogs');
      spyOn($scope, 'resetForm');

      var promise = $scope.submitComment({
        comments: 'test'
      });

      promise.then(function (data) {
        expect(data).toEqual(data);
        expect($window.alert).toHaveBeenCalledWith(
          'Comment posted');
        expect($scope.loadLogs).toHaveBeenCalled();
        expect($scope.resetForm).toHaveBeenCalled();
      });

      $scope.$apply();
      expect($api.create.calls.count()).toEqual(1);
    });
  });
});